<?php

namespace App\Http\Controllers\APIs\v1;

use App\Http\Requests\VerifyOTPRequest;
use Exception;
use Illuminate\Support\Facades\DB;
use Illuminate\Validation\ValidationException;
use SpaceO\RESTAuth\Traits\VerifyOTPTrait;
use SpaceO\RESTAuth\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Driver;

class VerifyOTPController extends Controller
{

    use VerifyOTPTrait;

    function verifyOTP(VerifyOTPRequest $request)
    {

        try {

            DB::beginTransaction();

            $user = auth()->user();
            if ($user instanceof User) {
                User::where('id', $user->id)->update(
                    array_combine($this->OTPVerifiedFields(), $this->OTPVerifiedValues())
                );
            } else {
                Driver::where('id', $user->id)->update(
                    array_combine($this->OTPVerifiedFields(), $this->OTPVerifiedValues())
                );
            }

            DB::commit();

            return response()->json([
                'message' => __('rest-auth::auth.otp.verified')
            ]);
        } catch (ValidationException $e) {

            return response()->json([
                'message' => $this->validator_message($e)
            ], 422);
        } catch (Exception $e) {

            return response()->json([
                'message' => $this->exception_message($e)
            ], 500);
        }
    }
}
