<?php

namespace App\Http\Controllers\APIs\v1;

use App\Models\Driver;
use App\Models\User;
use Exception;
use Illuminate\Validation\ValidationException;
use SpaceO\RESTAuth\Traits\UpdatePasswordTrait;
use SpaceO\RESTAuth\Http\Controllers\Controller;
use SpaceO\RESTAuth\Http\Requests\UpdatePasswordRequest;

class UpdatePasswordController extends Controller
{
    
    use UpdatePasswordTrait;
    public function updatePassword(UpdatePasswordRequest $request)
    {
        
        try {
           
            $user = auth()->user();
            
            if ($user instanceof User) {
                User::where('id', $user->id)->update([
                'password'=> bcrypt($request->new_password)
            ]);
        }
        else{
            Driver::where('id', $user->id)->update([
                'password'=> bcrypt($request->new_password)
            ]);
        }

            return response()->json([
                'message'=> __('rest-auth::responses.password_updated')
            ]);
        } catch (ValidationException $e) {

            return response()->json([ 
                'message' => $this->validator_message($e)
            ], 422);
        } catch (Exception $e) {
            
            return response()->json([
                'message' => $this->exception_message($e)
            ], 500);
        }
    }
}
