<?php

namespace App\Http\Controllers\APIs\v1;

use App\Http\Controllers\Controller;
use App\Models\Terminal;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class TerminalController extends Controller
{
    public function getTerminals(Request $request)
    {
        
        try {
            $terminals = [];
            $data = Terminal::select('pickup_location','dropoff_location')->distinct()->get();
            foreach($data as $d){
                $terminals['pickup'][] = $d->pickup_location;
                $terminals['dropoff'][] = $d->dropoff_location;
            }
            
            return response()->json([
                'message' => __('api.terminal.success'),
                'data' => $terminals
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'message' => 'An error occurred while fetching terminals.',
                'error' => $e->getMessage(), // Include the error message for debugging
            ], 500);
        }
    }
}
