<?php

namespace App\Http\Controllers\APIs\v1;

use App\Http\Controllers\Controller;
use App\Models\Subscription;
use App\Models\Driver;
use App\Models\UserSubscription;
use Illuminate\Http\Request;
use App\Http\Controllers\APIs\v1\PaymentController;
use App\Http\Requests\DriverSubscriptionRequest;
use App\Services\StripeService;
use Carbon\Carbon;

class SubscriptionController extends Controller
{
    protected $paymentController;
    protected $stripeService;

    public function __construct(PaymentController $paymentController, StripeService $stripeService)
    {
        $this->paymentController = $paymentController;
        $this->stripeService = $stripeService;
    }

    public function getPlans(Request $request)
    {
        $final_data = [];
        $stripePlan = $this->stripeService->getPlan();
     
        foreach ($stripePlan as $plan) {
            if(isset($plan->metadata['type']) && $plan->metadata['type'] === '4u-driver'){

          
            if ($plan->interval_count == 1 && $plan->interval == "month") {
                $type = "Monthly";
                $name = "Monthly";
            } else if ($plan->interval_count == 3 && $plan->interval == "month") {
                $type = $plan->interval_count . "-Months";
                $name = "Quaterly";
            } else if ($plan->interval_count == 1 && $plan->interval == "year") {
                $type = "1-Year";
                $name = "Annually";
            }
            $sub_data = UserSubscription::where('subscribable_id', auth()->user()->id)->where('subscribable_type', 'App\Models\Driver')->orderBy('id', 'desc')->first();

            if ($sub_data) {
                $dateString = $sub_data->end_date;

                // Convert the date to a DateTime object
                $dateTime =  Carbon::parse($dateString);;

                // Format the date in the desired format
                $formattedDate = $dateTime->format('F j, Y');

                $todayDate = date('Y-m-d');
                if ($sub_data->end_date > $todayDate) {
                    $daysDifference = "" . calculateDaysDifference($todayDate, $sub_data->end_date);
                } else {
                    $daysDifference = "0";
                }
            }

            $data['id'] = $plan->id;
            $data['subscription_name'] = $name;
            $data['price'] = $plan->amount / 100;
            $data['subscription_type'] = $type;
            $data['exp_days'] = $daysDifference ?? '';
            $data['exp_date'] = $formattedDate ?? '';
            $data['is_active'] = $sub_data ? (($plan->id == $sub_data->subscription_id) ? 1 : 0) : 0;
            $final_data[] = $data;
        }
        }
        usort($final_data, function ($a, $b) {
            return $a['price'] - $b['price'];
        });
        return response()->json([
            'message' => __('api.subscription.get_list'),
            'data' => $final_data
        ]);
    }

    public function driverSubscription(DriverSubscriptionRequest $request)
    {
        try {
            $driver = auth()->user();
            $driverId = $driver->id;
            $customerId = $driver->driver_customer_stripe_id; 
            $add_card = $this->stripeService->createCard($customerId,$request->card_token);
            
            $subscription =  $this->stripeService->subscribeDriver(
                $customerId,
                $request->plan_id,
                $request->card_token,
            );
           
            // Find the selected subscription plan
            $subscription = $this->stripeService->getPlanDetail($request->plan_id);

            // Calculate start and end dates based on the subscription plan
            $dates = calculateSubscriptionDates($subscription->interval, $subscription->interval_count);
            $planId = $request->plan_id;
            // Create a new UserSubscription instance
            $data = new UserSubscription([
                'subscription_id' => $planId,
                'start_date' => $dates['start_date'],
                'end_date' => $dates['end_date'],
                'plan_price' => $subscription->amount / 100,
                'subscription_type' => 1
            ]);

            // Associate the subscription with the plan
            // $data->subscription()->associate($subscription);

            // Associate the subscription with the driver
            $data->subscribable_id = $driverId;
            $data->subscribable_type = Driver::class;

            // Save the subscription detail to the database
            $data->save();

            return response()->json([
                'message' => __('api.subscription.subs_success'),
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'message' => $e->getMessage(),
                // 'errors' => $e->getMessage(),
            ], 500);
        }
    }
}
