<?php

namespace App\Http\Controllers\APIs\v1;

use App\Http\Requests\SocialLoginRequest;
use App\Models\User;
use Illuminate\Validation\ValidationException;
use SpaceO\RESTAuth\Http\Controllers\Controller;
use SpaceO\RESTAuth\RESTAuth;
use SpaceO\RESTAuth\Traits\Auth\SocialLoginTrait;
use SpaceO\RESTAuth\Traits\SendOTPTrait;
use Exception;
use Illuminate\Support\Arr;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;
use App\Services\UpdateSocialiteInfo;
use SpaceO\RESTAuth\Services\PersonalTokenService;
use SpaceO\RESTAuth\Services\InvalidateIfUserIsInactive;
use App\Services\SendbirdService;
use App\Services\StripeService;
use Illuminate\Validation\Rule;
use Twilio\Rest\Client;

class SocialLoginController extends Controller
{

    use SocialLoginTrait;
    use SendOTPTrait;
    private $stripeService;
    private $sendbirdService;
    private int $otpLength;

    public function __construct(StripeService $stripeService, SendbirdService $sendbirdService)
    {
        $this->stripeService = $stripeService;
        $this->sendbirdService = $sendbirdService;
        $this->otpLength = config('rest_auth.otp_length');
    }

    public function socialLogin(SocialLoginRequest $request)
    {
        try {

            DB::beginTransaction();
            $socialInfoService = new UpdateSocialiteInfo;

            $user = RESTAuth::$userModel::query()
                ->whereHas('socialLogins', function ($builder) use ($request) {
                    $builder->where([
                        'social_id' => $request->social_id,
                        'type' => $request->social_type,
                    ]);
                })
                ->first();

            if ($request->social_type == "1") {
                $social_type = 1;
            } else if ($request->social_type == "2") {
                $social_type = 2;
            } else if ($request->social_type == "4") {
                $social_type = 4;
            }
            if (!$user) {
                $user = RESTAuth::$userModel::where('email', $request->email)->first();
                if ($user) {
                    return response()->json([
                        'message' => "the email is already connected to a account"
                    ], 500);
                } else {
                    if ($request->mobile == "") {


                        $user = [
                            'id' => 0,
                            'name' => $request->name,
                            'email' => $request->email,
                            'isd_code' => "",
                            'mobile' => "",
                            'profile_image' => "",
                            'is_profile_completed' => 0,
                            'step' => 0,
                            'is_verified' => 0,
                            'login_type' => $social_type,
                            'social_id' => $request->social_id,
                            'is_subscribed' => 0,
                            'rating' => "0.0"
                        ];
                        return response()->json([
                            'message' => "User do not have social account.",
                            'data' => [
                                'user' => $user,
                                'access_token' => "",
                                'refresh_token' => "",
                                'is_already_logged_in' => false,
                                'is_social_register' => 0
                            ],
                        ]);
                    } else {
                        $user = RESTAuth::$userModel::where('email', $request->email)->first();
                        if ($user) {
                            return response()->json([
                                'message' => "the email is already connected to a account"
                            ], 500);
                        } else {
                            if (isset($request->mobile)) {
                                $request->merge([
                                    'usermobile' => $request->isd_code . $request->mobile,
                                ]);
                                $request->validate(
                                    [
                                        'mobile' => Rule::unique('users', 'mobile'),
                                        'usermobile' => 'phone:AUTO',
                                    ],
                                    [
                                        'usermobile.phone' => 'Please enter a valid mobile number.', // custom message
                                    ]
                                );
                            }
                            $stripeCustomer = $this->stripeService->createCustomer($request->email, $request->name,1);
                            $sendbirdUser = $this->sendbirdService->createUser($request->name, $request->name, "https://sendbird.com/main/img/profiles/profile_05_512px.png");
                            $user = RESTAuth::$userModel::create([
                                'uuid' => GetUuid(),
                                'password' => bcrypt(Str::random()),
                                'email' => $request->email,
                                'isd_code' => $request->isd_code,
                                'mobile' => $request->mobile,
                                'gender' => $request->gender,
                                'dob' => $request->dob,
                                'stripe_id' => $stripeCustomer->id,
                                'sendbird_chat_id' => $sendbirdUser['user_id'],
                                'email_verified_at' => $request->email ? now() : null,
                                'username' => $this->usernameFromEmail($request->email ?? uniqid()),
                                'name' => $request->name,
                                'profile_photo' => $request->profile_photo,
                                'account_merge' => 0,
                                'is_social_account' => 1,
                            ]);
                        }
                        $socialInfoService->create($user, $request);
                    }
                }
            }

            if (!$user->wasRecentlyCreated) {
                (new InvalidateIfUserIsInactive)($user);
            }

            $personalTokenService = new PersonalTokenService($user);
            $personalTokenService->deleteTheExistingTokensOfDevices();
            // $isAlreadyLoggedIn = $personalTokenService->isLoggedInInOtherDevice();
            $tokenInstance = $personalTokenService->createToken();

            DB::commit();
            $user = $user->only('id', 'name', 'email', 'isd_code', 'mobile', 'profile_photo', 'mobile_verified_at');
            if ($user) {
                $user['profile_image'] = ($user['profile_photo'] == null) ? "" : config('services.aws.aws_cloud_url') . $user['profile_photo'];
                $user['is_profile_completed'] = 0;
                $user['step'] = 0;
                $user['rating'] = "0.0";
                if ($user['isd_code'] == null) {
                    $user['isd_code'] = "";
                }
                if ($user['mobile'] == null) {
                    $user['mobile'] = "";
                }
                if ($user['mobile_verified_at'] == null) {
                    $user['is_verified'] = 0;
                    $otp = $this->sendOTPOnMobile($request);
                    User::where('id', $user['id'])->update(
                        array_combine($this->OTPFields(), [
                            $otp, now()->addMinutes(config('rest_auth.otp_expires_in'))
                        ])
                    );
                } else {
                    $user['is_verified'] = 1;
                }
                $user['login_type'] = $social_type;
                $user['social_id'] = $request->social_id;
                $user['is_subscribed'] = 0;
                $user = Arr::except($user, ['profile_photo', 'mobile_verified_at']);
            }
            return response()->json([
                'message' => __('rest-auth::auth.signed_in'),
                'data' => [
                    'user' => $user,
                    'access_token' => $tokenInstance->plainTextToken,
                    'refresh_token' => $tokenInstance->plainTextRefreshToken,
                    'is_already_logged_in' => $isAlreadyLoggedIn ?? false,
                    'is_social_register' => 1
                ],
            ]);
        } catch (ValidationException $e) {

            return response()->json([
                'message' => $this->validator_message($e)
            ], 422);
        } catch (Exception $e) {

            return response()->json([
                'message' => $this->exception_message($e)
            ], 500);
        }
    }

    public function sendOTPOnMobile($request)
    {
        $otp = $this->generateOTP();

        // Send SMS on mobile number via HTTP client
        $receiverNumber = '"' . $request->isd_code . $request->mobile . '"';
        if($request->device_type == "android")
        {
            $message = "Your one time password for 4u taxi booking app is : " . $otp . ". fjmjoET9YaI";
        }
        else{
            $message = "Your one time password for 4u taxi booking app is " . $otp;
        }

        try {

            $account_sid = config('services.twilio.account_sid');
            $auth_token = config('services.twilio.auth_token');
            $twilio_number = config('services.twilio.twilio_number');

            $client = new Client($account_sid, $auth_token);
            $client->messages->create($receiverNumber, [
                'from' => $twilio_number,
                'body' => $message
            ]);

            // dd('SMS Sent Successfully.');

        } catch (Exception $e) {
            // dd("Error: ". $e->getMessage());
        }
        return $otp;
    }
}
