<?php

namespace App\Http\Controllers\APIs\v1;

use Illuminate\Support\Facades\DB;
use SpaceO\RESTAuth\Traits\AppVersionTrait;
use SpaceO\RESTAuth\Http\Controllers\Controller;
use Illuminate\Support\Str;

class SettingController extends Controller
{
    
    use AppVersionTrait;

    public function insertDummyRecords()
    {
        $dummyData = [
            [
                'uuid' => GetUuid(),
                'car_type_name' => 'Regular',
                'car_description' => 'This is a regular car',
                'car_capacity' => 4,
                'car_image' => 'https://imgd.aeplcdn.com/370x208/n/cw/ec/130591/fronx-exterior-right-front-three-quarter-4.jpeg',
                'is_active' => 1,
            ],
            [
                'uuid' => GetUuid(),
                'car_type_name' => 'Semi-Premium',
                'car_description' => 'This is a semi premium car',
                'car_capacity' => 5,
                'car_image' => 'https://imgd.aeplcdn.com/370x208/n/cw/ec/130591/fronx-exterior-right-front-three-quarter-4.jpeg',
                'is_active' => 1,
            ],
            [
                'uuid' => GetUuid(),
                'car_type_name' => 'Premium',
                'car_description' => 'This is a premium car',
                'car_capacity' => 4,
                'car_image' => 'https://imgd.aeplcdn.com/370x208/n/cw/ec/130591/fronx-exterior-right-front-three-quarter-4.jpeg',
                'is_active' => 1,
            ],
        ];
    
        // Use the DB facade to insert the data
        DB::table('cars')->insert($dummyData);
    
        return "Dummy records inserted successfully.";
    }

    public function insertDummyFaq()
    {
        $dummyData = [
            [
                'question' => 'Test Question 1',
                'answer' => 'Test Answer 1',
                'type' => 1,
                
            ],
            [
                'question' => 'Test Question 1',
                'answer' => 'Test Answer 1',
                'type' => 2,
            ],
        ];
    
        // Use the DB facade to insert the data
        DB::table('faqs')->insert($dummyData);
    
        return "Dummy records inserted successfully.";
    }

    public function insertDummyReason()
    {
        $dummyData = [
            [
                'reason' => 'Test Reason 2',
                'type' => 1,
                
            ],
            [
                'reason' => 'Test Reason 2',
                'type' => 2,
            ],
            [
                'reason' => 'Test Reason 1',
                'type' => 3,
            ],
            [
                'reason' => 'Test Reason 2',
                'type' => 3,
            ],
        ];
    
        // Use the DB facade to insert the data
        DB::table('cancel_reasons')->insert($dummyData);
    
        return "Dummy records inserted successfully.";
    }

    public function insertDummyHelp()
    {
        $dummyData = [
            [
                'reason' => 'Test Help Topic 1',
                'type' => 1,
                
            ],
            [
                'reason' => 'Test Help Topic 1',
                'type' => 2,
            ],
        ];
    
        // Use the DB facade to insert the data
        DB::table('help_reasons')->insert($dummyData);
    
        return "Dummy records inserted successfully.";
    }

    public function insertDummyAir()
    {
        $dummyData = [
            [
                'uuid' => GetUuid(),
                'first_name' => 'Shola',
                'last_name' =>  'Transport',
                'password' => bcrypt('Shola@123'),
                'email' => 'sholacpa@gmail.com',
                'isd_code' => '+1',
                'mobile' => '4165556134',
                'stripe_id' => 'hkjsfhsjkd',
                'sendbird_chat_id' => 'sfshdfkjn',
                'type' => 2
                
            ],
            // [
            //     'uuid' => GetUuid(),
            //     'first_name' => 'Test',
            //     'last_name' =>  'abc',
            //     'password' => bcrypt(Str::random()),
            //     'email' => 'abc@gmail.com',
            //     'isd_code' => '+91',
            //     'mobile' => '8200886341',
            //     'stripe_id' => 'hkjsfhsjkui',
            //     'sendbird_chat_id' => 'sfshdfkjui',
            //     'type' => 2
            // ],
        ];
    
        // Use the DB facade to insert the data
        DB::table('air_transportations')->insert($dummyData);
    
        return "Dummy records inserted successfully.";
    }

    public function insertDummyTerminal()
    {
        $dummyData = [
            [
                'air_transportation_id' => 1,
                'pickup_location' => 'Columbus, OH, United States',
                'dropoff_location' => 'London, OH, United States',
                'terminal_type' => 'pier'
                
            ],
            [
                'air_transportation_id' => 2,
                'pickup_location' => 'NewJersey, OH, United States',
                'dropoff_location' => 'LosAngeles, OH, United States',
                'terminal_type' => 'pier'
            ],
        ];
    
        // Use the DB facade to insert the data
        DB::table('terminals')->insert($dummyData);
    
        return "Dummy records inserted successfully.";
    }

    public function insertDummyPromocode()
    {
        $dummyData = [
            [
                'promocode_name' => 'FREE2023',
                'discount' => 5,
                'discount_type' => 1,
                'start_date' => '2023-07-19',
                'end_date' => '2023-09-30',
                'is_active' => 1
                
            ],
            [
                'promocode_name' => 'FREE100',
                'discount' => 5,
                'discount_type' => 2,
                'start_date' => '2023-07-19',
                'end_date' => '2023-09-30',
                'is_active' => 1
            ],
            [
                'promocode_name' => 'FREEFIRST',
                'discount' => 5,
                'discount_type' => 1,
                'start_date' => '2023-07-19',
                'end_date' => '2023-10-30',
                'is_active' => 1
                
            ],
            [
                'promocode_name' => 'FREEFIRST100',
                'discount' => 5,
                'discount_type' => 2,
                'start_date' => '2023-07-19',
                'end_date' => '2023-10-30',
                'is_active' => 1
            ],
        ];
    
        // Use the DB facade to insert the data
        DB::table('promocodes')->insert($dummyData);
    
        return "Dummy records inserted successfully.";
    }

    public function updateData()
    {
        
    }
}
