<?php

namespace App\Http\Controllers\APIs\v1;

use App\Http\Requests\SendOTPRequest;
use SpaceO\RESTAuth\Traits\SendOTPTrait;
use SpaceO\RESTAuth\Http\Controllers\Controller;
use Exception;
use Illuminate\Http\Client\ConnectionException;
use Illuminate\Http\Client\RequestException;
use Illuminate\Support\Facades\DB;
use Illuminate\Validation\ValidationException;
use Twilio\Rest\Client;
use App\Models\User;
use App\Models\Driver;

class SendOTPController extends Controller
{

    use SendOTPTrait;

    public function sendOTP(SendOTPRequest $request)
    {
        try {

            DB::beginTransaction();

            if ($request->verification_for === 'email') {

                $otp = $this->sendOTPOnEmail();
            } else {

                $otp = $this->sendOTPOnMobile();
            }

            $user = auth()->user();
            if ($user instanceof User) {
                User::where('id', $user->id)->update(
                    array_combine($this->OTPFields(), [
                        $otp, now()->addMinutes(config('rest_auth.otp_expires_in'))
                    ])
                );
            } else {
                Driver::where('id', $user->id)->update(
                    array_combine($this->OTPFields(), [
                        $otp, now()->addMinutes(config('rest_auth.otp_expires_in'))
                    ])
                );
            }

            DB::commit();

            return response()->json([
                'message' => __('rest-auth::auth.otp.sent', [
                    'over' => $this->isEmailVerification()
                        ? $request->email
                        : "{$request->isd_code}{$request->mobile}"
                ]),
            ]);
        } catch (ConnectionException $e) {

            return response()->json(['message' => __('rest-auth::auth.otp.timed_out')], 500);
        } catch (RequestException $e) {

            return response()->json(['message' => __('rest-auth::auth.otp.something_went_wrong')], 500);
        } catch (ValidationException $e) {

            return response()->json([
                'message' => $this->validator_message($e)
            ], 422);
        } catch (Exception $e) {

            return response()->json([
                'message' => $this->exception_message($e)
            ], 500);
        }
    }

    public function sendOTPOnMobile(): int
    {
        $otp = $this->generateOTP();
        $device_type = auth()->user()->device->device_type;
        
        // Send SMS on mobile number via HTTP client
        $receiverNumber = '"' . request()->user()->isd_code . request()->user()->mobile . '"';

        if ($device_type == "2") {
            if (request()->user_type == 1) {
                $message = "Your one time password for 4u taxi booking app is : " . $otp . ". XDvzEK/CvsW";
            } else {
                $message = "Your one time password for 4u taxi booking app is : " . $otp . ". V01UKdFq6XR";
            }
        } else {
            $message = "Your one time password for 4u taxi booking app is " . $otp;
        }
        try {

            $account_sid = config('services.twilio.account_sid');
            $auth_token = config('services.twilio.auth_token');
            $twilio_number = config('services.twilio.twilio_number');

            $client = new Client($account_sid, $auth_token);
            $client->messages->create($receiverNumber, [
                'from' => $twilio_number,
                'body' => $message
            ]);

            // dd('SMS Sent Successfully.');

        } catch (Exception $e) {
            // dd("Error: " . $e->getMessage());
        }
        return $otp;
    }
}
