<?php

namespace App\Http\Controllers\APIs\v1;

use App\Http\Controllers\Controller;
use App\Http\Requests\AirTransportReviewRequest;
use App\Http\Requests\DriverReviewRequest;
use App\Models\AirTransportationBooking;
use App\Models\Booking;
use App\Models\BookingPayment;
use App\Models\Card;
use App\Models\Driver;
use App\Services\StripeService;

class ReviewController extends Controller
{
    protected $stripeService;

    public function __construct(StripeService $stripeService)
    {
        $this->stripeService = $stripeService;
    }
    public function giveDriverReview(DriverReviewRequest $request)
    {
        try {

            // Assuming you have a user instance available
            $user = $request->user();

            $driver = Driver::find($request->driver_id);

            // Check if the driver exists
            if (!$driver) {
                return response()->json([
                    'error' => 'Driver not found',
                ], 404);
            }

            // Create a review instance
            $driver->review()->create(
                [
                    'user_id' => $user->id,
                    'review' => $request->review,
                    'rating' => $request->rating,
                    'booking_id' => $request->booking_id,
                    'tip' => isset($request->tip) ? $request->tip : 0,
                    'review_type' => 1, // Assuming 1 represents a review for a driver
                ]
            );
            $booking = Booking::find($request->booking_id);
            $upbooking = Booking::where('id', $request->booking_id)->update([
                'driver_tip' => $request->tip
            ]);
            if(isset($request->tip) && $request->tip > 0){
                $gettoken = Card::where('id', $booking->payment_card_id)->first();
                $token = $gettoken->card_token;
                $payment = $this->stripeService->createPaymentIntent($request->tip, $token, $booking->driver->stripe_id, $booking->users->stripe_id, "Ride Tip Amount");
                BookingPayment::create([
                    'booking_id' => $request->booking_id,
                    'payment_amount' => $request->tip,
                    'payment_method' => $payment['payment_method_types'][0],
                    'transaction_id' => $payment['id'],
                    'payment_status' => 2,
                    'payment_type' => 2
                ]);
            }
           
            return response()->json([
                'message' => __('api.review.review_given'),
            ]);
        } catch (\Exception $e) {

            return response()->json([
                'error' => 'An error occurred while giving the review.',
            ], 500);
        }
    }

    public function giveAirtransportationReview(AirTransportReviewRequest $request)
    {
        try {

            // Assuming you have a user instance available
            $user = $request->user();

            // Check if the booking exists
            $booking = AirTransportationBooking::find($request->booking_id);
            if (!$booking) {
                return response()->json([
                    'error' => 'Booking not found',
                ], 404);
            }

            // Create a review instance
            $booking->review()->create(
                [
                    'user_id' => $user->id,
                    'review' => $request->review,
                    'rating' => $request->rating,
                    'review_type' => 2, // Assuming 2 represents a review for an airline
                ]
            );

            return response()->json([
                'message' => __('api.review.review_given'),
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'error' => 'An error occurred while giving the review.',
            ], 500);
        }
    }
}
