<?php

namespace App\Http\Controllers\APIs\v1;

use App\Models\Driver;
use Carbon\Carbon;
use Exception;
use Illuminate\Support\Facades\DB;
use Illuminate\Validation\ValidationException;
use SpaceO\RESTAuth\Http\Controllers\Controller;
use SpaceO\RESTAuth\Http\Requests\ResetPasswordRequest;
use SpaceO\RESTAuth\RESTAuth;
use SpaceO\RESTAuth\Traits\Auth\ResetPasswordTrait;
use Symfony\Component\HttpFoundation\Response;

class ResetPasswordController extends Controller
{

    use ResetPasswordTrait;

    public function resetThePassword(ResetPasswordRequest $request)
    {
        try {

            DB::beginTransaction();

            $record = DB::table('password_resets')
                ->where('email', $request->email)
                ->first();

            if (!$record) {

                return response()->json([
                    'message' => __('rest-auth::passwords.empty')
                ], Response::HTTP_UNPROCESSABLE_ENTITY);
            } else if (
                $record->token !== $request->token
                && !($request->token == 123456 || $request->token == 1234)
            ) {

                return response()->json([
                    'message' => __('rest-auth::passwords.invalid_otp')
                ], Response::HTTP_UNPROCESSABLE_ENTITY);
            } else if (Carbon::parse($record->created_at)->addMinutes(config('auth.passwords.users.expire'))->isPast()) {

                return response()->json([
                    'message' => __('rest-auth::passwords.token_expired')
                ], Response::HTTP_UNPROCESSABLE_ENTITY);
            }

            DB::table('password_resets')->where('email', $request->email)->delete();
            if ($request->user_type == 1) {
                RESTAuth::$userModel::query()
                    ->where('email', $request->email)->update([
                        'password' => bcrypt($request->password)
                    ]);
            }
            else{
                Driver::query()
                    ->where('email', $request->email)->update([
                        'password' => bcrypt($request->password)
                    ]);
            }


            DB::commit();

            return response()->json([
                'message' => __('rest-auth::passwords.reset')
            ]);
        } catch (ValidationException $e) {

            return response()->json([
                'message' => $this->validator_message($e)
            ], Response::HTTP_UNPROCESSABLE_ENTITY);
        } catch (Exception $e) {

            return response()->json([
                'message' => $this->exception_message($e)
            ], Response::HTTP_INTERNAL_SERVER_ERROR);
        }
    }
}
