<?php

namespace App\Http\Controllers\APIs\v1;

use App\Http\Requests\DriverRegisterRequest;
use Exception;
use Illuminate\Support\Facades\DB;
use SpaceO\RESTAuth\Traits\Auth\RegisterTrait;
use SpaceO\RESTAuth\Traits\SendOTPTrait;
use SpaceO\RESTAuth\Http\Controllers\Controller;
use App\Http\Requests\RegisterRequest;
use App\Http\Requests\SocialLoginRequest;
use SpaceO\RESTAuth\RESTAuth;
use Illuminate\Validation\ValidationException;
use SpaceO\RESTAuth\Services\PersonalTokenService;
use App\Models\Driver;
use App\Models\VehicleInfo;
use App\Services\SendbirdService;
use App\Services\StripeService;
use Illuminate\Support\Arr;
use App\Models\User;
use Illuminate\Support\Facades\Log;
use Twilio\Rest\Client;

class RegisterController extends Controller
{
    use SendOTPTrait;

    use RegisterTrait;

    private $stripeService;
    private $sendbirdService;
    private int $otpLength;

    public function __construct(StripeService $stripeService, SendbirdService $sendbirdService)
    {
        $this->stripeService = $stripeService;
        $this->sendbirdService = $sendbirdService;
        $this->otpLength = config('rest_auth.otp_length');
    }

    public function register(RegisterRequest $request)
    {
        try {
            if ($request->social_type != 0) {
                // $social=new SocialController;
                $socialLoginRequest = new SocialLoginRequest();
                $socialLoginRequest->merge($request->all());
                return app('App\Http\Controllers\APIs\v1\SocialLoginController')->socialLogin($socialLoginRequest);
            }
            DB::beginTransaction();
            $stripeCustomer = $this->stripeService->createCustomer($request->email, $request->name, 1);
            $profilePhoto = $request->profile_photo ? config('services.aws.aws_cloud_url') . $request->profile_photo : "https://sendbird.com/main/img/profiles/profile_05_512px.png";

            $sendbirdUser = $this->sendbirdService->createUser($request->name, $request->name, $profilePhoto);
            $user = RESTAuth::$userModel::create([
                'name' => $request->name,
                'profile_photo' => $request->profile_photo,
                'username' => $request->name,
                'email' => $request->email,
                'password' => bcrypt($request->password),
                'isd_code' => $request->isd_code,
                'mobile' => $request->mobile,
                'gender' => $request->gender,
                'dob' => $request->dob,
                'stripe_id' => $stripeCustomer->id,
                'sendbird_chat_id' => $sendbirdUser['user_id'],
            ]);

            $personalTokenService = new PersonalTokenService($user);
            $tokenInstance = $personalTokenService->createToken();

            DB::commit();
            $user = $user->only('id', 'name', 'email', 'isd_code', 'mobile', 'mobile_verified_at', 'profile_photo', 'stripe_id', 'sendbird_chat_id');
            if ($user) {
                $user['profile_image'] = ($user['profile_photo'] == null) ? "" : config('services.aws.aws_cloud_url') . $user['profile_photo'];
                $user['is_profile_completed'] = 0;
                $user['step'] = 0;

                if ($user['mobile_verified_at'] == null) {

                    $user['is_verified'] = 0;
                } else {
                    $user['is_verified'] = 1;
                }
                $user['login_type'] = 0;
                $user['social_id'] = "";
                $user['rating'] = "0.0";
                $user['is_subscribed'] = 0;
            }
            $user = Arr::except($user, ['mobile_verified_at', 'profile_photo']);
            $request->merge(["key" => "fjmjoET9YaI"]);
            $otp = $this->sendOTPOnMobile($request);
            User::where('id', $user['id'])->update(
                array_combine($this->OTPFields(), [
                    $otp, now()->addMinutes(config('rest_auth.otp_expires_in'))
                ])
            );
            return response()->json([
                'message' => __('rest-auth::auth.signed_up'),
                'data' => [
                    'user' => $user,
                    'is_already_logged_in' => false,
                    'access_token' => $tokenInstance->plainTextToken,
                    'refresh_token' => $tokenInstance->plainTextRefreshToken,
                    'is_social_register' => 0
                ]
            ]);
        } catch (ValidationException $e) {
            DB::rollback();  // Rollback the transaction in case of an exception
            return response()->json([
                'message' => $this->validator_message($e)
            ], 422);
        } catch (Exception $e) {
            DB::rollback();  // Rollback the transaction in case of an exception
            return response()->json([
                'message' => $this->exception_message($e)
            ], 500);
        }
    }

    public function driverRegister(DriverRegisterRequest $request)
    {
        try {

            DB::beginTransaction();
            $stripeCustomer = $this->stripeService->createCustomer($request->email, $request->full_name, 2);
            $normalCustomer = $this->stripeService->createCustomer($request->email, $request->name, 1);
            $profilePhoto = $request->profile_photo ? config('services.aws.aws_cloud_url') . $request->profile_photo : "https://sendbird.com/main/img/profiles/profile_05_512px.png";
            $sendbirdUser = $this->sendbirdService->createUser($request->full_name, $request->full_name, $profilePhoto);
            $user = Driver::create([
                'profile_image' => $request->profile_photo,
                'full_name' => $request->full_name,
                'email' => $request->email,
                'password' => bcrypt($request->password),
                'isd_code' => $request->isd_code,
                'mobile' => $request->mobile,
                'stripe_id' => $stripeCustomer->id,
                'driver_customer_stripe_id' => $normalCustomer->id,
                'sendbird_chat_id' => $sendbirdUser['user_id'],
                'step' => 1,
            ]);
            $vehicle_info = new VehicleInfo();
            $vehicle_info->driver_id = $user->id;
            $vehicle_info->save();
            $personalTokenService = new PersonalTokenService($user);
            $tokenInstance = $personalTokenService->createToken();

            DB::commit();
            $user = $user->only('id', 'full_name', 'email', 'isd_code', 'mobile', 'mobile_verified_at', 'profile_image', 'stripe_id', 'sendbird_chat_id');
            if ($user) {
                $user['name'] = $user['full_name'];
                $user['profile_image'] = ($user['profile_image'] == null) ? "" : config('services.aws.aws_cloud_url') . $user['profile_image'];
                $user['is_profile_completed'] = 0;
                $user['step'] = 1;
                $user['login_type'] = 0;
                $user['social_id'] = "";
                $user['is_subscribed'] = 0;
                $user['rating'] = "0.0";
                if ($user['mobile_verified_at'] == null) {

                    $user['is_verified'] = 0;
                    $request->merge(["key" => "D5g134hIW39"]);
                    $otp = $this->sendOTPOnMobile($request);
                    Driver::where('id', $user['id'])->update(
                        array_combine($this->OTPFields(), [
                            $otp, now()->addMinutes(config('rest_auth.otp_expires_in'))
                        ])
                    );
                } else {
                    $user['is_verified'] = 1;
                }
            }
            $user = Arr::except($user, ['mobile_verified_at', 'full_name']);
            return response()->json([
                'message' => __('rest-auth::auth.signed_up'),
                'data' => [
                    'user' => $user,
                    'is_already_logged_in' => false,
                    'access_token' => $tokenInstance->plainTextToken,
                    'refresh_token' => $tokenInstance->plainTextRefreshToken,
                    'is_social_register' => 0
                ]
            ]);
        } catch (ValidationException $e) {
            DB::rollback();  // Rollback the transaction in case of an exception
            return response()->json([
                'message' => $this->validator_message($e)
            ], 422);
        } catch (Exception $e) {
            DB::rollback();  // Rollback the transaction in case of an exception
            return response()->json([
                'message' => "An error occurred when registering"
            ], 500);
        }
    }

    public function sendOTPOnMobile($request)
    {
        $otp = $this->generateOTP();

        // Send SMS on mobile number via HTTP client
        $receiverNumber = '"' . $request->isd_code . $request->mobile . '"';
        if ($request->device_type == "android") {
            $message = "Your one time password for 4u taxi booking app is : " . $otp . "." . $request->key;
        } else {
            $message = "Your one time password for 4u taxi booking app is " . $otp;
        }


        try {

            $account_sid = config('services.twilio.account_sid');
            $auth_token = config('services.twilio.auth_token');
            $twilio_number = config('services.twilio.twilio_number');

            $client = new Client($account_sid, $auth_token);
            $client->messages->create($receiverNumber, [
                'from' => $twilio_number,
                'body' => $message
            ]);

            // dd('SMS Sent Successfully.');

        } catch (Exception $e) {
            // dd("Error: ". $e->getMessage());
        }
        return $otp;
    }
}
