<?php

namespace App\Http\Controllers\APIs\v1;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\CancelReason;
use Illuminate\Support\Facades\Validator;

class ReasonController extends Controller
{
    public function get_list(Request $request)
    {
        $validator = Validator::make(['type' => $request->type], [
            'type' => 'required|integer|lte:3|gte:1',
        ]);
    
        if ($validator->fails()) {
            return response()->json([
                'message' => __('api.validation_failed'),
                'errors' => $validator->errors(),
            ], 422);
        }
    
        try {
            $reasons = CancelReason::select('id', 'reason')
                ->where('type', $request->type)
                ->where('is_active', 1)
                ->get();
    
            return response()->json([
                'message' => __('api.reason.reason_fetch_success'),
                'data' => $reasons,
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'message' => __('api.reason.error_occurred'),
                'error' => $e->getMessage(),
            ], 500);
        }
    }
}
