<?php
namespace App\Http\Controllers\Api;

use App\Models\Parcel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class ParcelController extends Controller
{
    public function store(Request $request) {
        $parcel = Parcel::create([
            'sender_id' => auth()->id(),
            'pickup_address' => $request->pickup_address,
            'delivery_address' => $request->delivery_address,
        ]);
        return response()->json($parcel);
    }

    public function assign(Request $request, $id) {
        $parcel = Parcel::findOrFail($id);
        $parcel->driver_id = $request->driver_id;
        $parcel->status = 'assigned';
        $parcel->save();
        return response()->json(['message' => 'Parcel assigned']);
    }

    public function track($id) {
        $parcel = Parcel::findOrFail($id);
        return response()->json([
            'status' => $parcel->status,
            'driver_location' => $parcel->driver->latestLocation ?? null
        ]);
    }

    public function updateStatus(Request $request, $id) {
        $parcel = Parcel::findOrFail($id);
        $parcel->status = $request->status;
        $parcel->save();
        return response()->json(['message' => 'Status updated']);
    }
}
