<?php

namespace App\Http\Controllers\APIs\v1;

use App\Http\Controllers\Controller;
use App\Models\Notification;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class NotificationController extends Controller
{
    public function getNotification(Request $request)
    {
        try {
            $userId = auth()->user()->id; 
            $notifications = Notification::select(
                'id',
                'notification_title',
                'notification_desc',
                'notification_object_id',
                'notification_object_type',
                DB::raw('COALESCE(notification_icon, "") AS notification_icon'),
                'created_at'
            )->where('receiver_id', $userId)->orderBy('created_at', 'desc')->get();

            $notifications = $notifications->map(function ($notification) {
                $timeDifference = getCustomTimeDifference($notification->created_at);
                $notification->notification_time = $timeDifference;
                $notification->makeHidden(['created_at']);
                return $notification;
            });

            return response()->json([
                'message' => __('api.notification.success'),
                'data' => $notifications
            ]);
        } catch (\Exception $e) {
            // Log the error if needed
            // Log::error($e->getMessage());

            return response()->json([
                'message' => __('api.notification.error'),
                // 'error' => $e->getMessage(),
            ], 500);
        }

    }

}
