<?php

namespace App\Http\Controllers\APIs\v1;

use App\Models\Driver;
use App\Models\SocialLogin;
use App\Models\User;
use App\Models\UserSubscription;
use Exception;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\ValidationException;
use SpaceO\RESTAuth\Traits\Auth\LoginTrait;
use SpaceO\RESTAuth\Http\Controllers\Controller;
use SpaceO\RESTAuth\Http\Requests\LoginRequest;
use SpaceO\RESTAuth\RESTAuth;
use SpaceO\RESTAuth\Services\InvalidateIfUserIsInactive;
use SpaceO\RESTAuth\Services\PersonalTokenService;
use SpaceO\RESTAuth\Services\UpdateLoginInfo;
use SpaceO\RESTAuth\Traits\SendOTPTrait;
use Twilio\Rest\Client;

class LoginController extends Controller
{

    use SendOTPTrait;
    use LoginTrait;
    private int $otpLength;
    public function __construct()
    {
        $this->otpLength = config('rest_auth.otp_length');
    }
    public function login(LoginRequest $request)
    {

        try {

            DB::beginTransaction();

            $condition = $this->generateConditionalMatch($request->login_type, $request->username);
            if ($request->user_type == 1) {
                $user = RESTAuth::$userModel::query()
                    ->select('id', 'name', 'email', 'isd_code', 'mobile', 'mobile_verified_at', 'password', 'profile_photo', 'sendbird_chat_id', 'stripe_id')
                    ->when(is_string($condition), function ($query) use ($condition) {
                        $query->whereRaw($condition);
                    }, function ($query) use ($condition) {
                        $query->where($condition);
                    })
                    ->first();

                if ($user) {
                    $socialuser = SocialLogin::where('user_id', $user->id)->first();
                    if ($socialuser) {
                        return response()->json([
                            'message' => "your account is associated with social account"
                        ], 422);
                    }
                    $user['profile_image'] = ($user['profile_photo'] == null) ? "" : config('services.aws.aws_cloud_url') . $user['profile_photo'];
                    $user['is_profile_completed'] = 0;
                    $user['step'] = 0;

                    if ($user->mobile_verified_at == null) {
                        $user['mobile_verified_at'] = "";
                        $user['is_verified'] = 0;
                        $otp = $this->sendOTPOnMobile($request);
                        User::where('id', $user['id'])->update(
                            array_combine($this->OTPFields(), [
                                $otp, now()->addMinutes(config('rest_auth.otp_expires_in'))
                            ])
                        );
                    } else {
                        $user['is_verified'] = 1;
                    }
                    $user['login_type'] = 0;
                    $user['social_id'] ="";
                    $user['rating'] = "0.0";
                    $user['is_subscribed'] = 0;
                    $user = Arr::except($user, ['profile_photo']);
                }
            } else {
                $user = Driver::query()
                    ->select('id', 'full_name as name', 'email', 'isd_code', 'mobile', 'mobile_verified_at', 'password', 'is_profile_completed', 'step', 'profile_image', 'is_approved','sendbird_chat_id', 'stripe_id','is_active')
                    ->when(is_string($condition), function ($query) use ($condition) {
                        $query->whereRaw($condition);
                    }, function ($query) use ($condition) {
                        $query->where($condition);
                    })
                    ->first();
                if ($user) {
                    $user['profile_image'] = ($user['profile_image'] == null) ? "" : config('services.aws.aws_cloud_url') . $user['profile_image'];
                    if ($user->mobile_verified_at == null) {
                        $user['mobile_verified_at'] = "";
                        $user['is_verified'] = 0;
                        $otp = $this->sendOTPOnMobile($request);
                        Driver::where('id', $user['id'])->update(
                            array_combine($this->OTPFields(), [
                                $otp, now()->addMinutes(config('rest_auth.otp_expires_in'))
                            ])
                        );
                    } else {
                        $user['is_verified'] = 1;
                    }
                    $user['login_type'] = 0;
                    $user['social_id'] ="";
                    $user['rating'] = "0.0";
                    $checksubscription = UserSubscription::where('subscribable_type', 'App\Models\Driver')->where('subscribable_id', $user->id)->first();
                    if($checksubscription)
                    {
                        $user['is_subscribed'] = 1;
                    }
                    else{
                        $user['is_subscribed'] = 0;
                    }
                }
            }


            if (!$user || !Hash::check($request->password, $user->password)) {

                return response()->json([
                    'message' => __('rest-auth::auth.failed')
                ], 422);
            } 
            else {
                if ($request->user_type == 2 && $user->is_approved != 1) {
                    return response()->json([
                        'message' => "Your account approval is pending, Please reach out to your administrator for assistance.",
                    ], 422);
                }else if ($request->user_type == 2 && $user->is_active != 1) {
                    return response()->json([
                        'message' => "Your account is not active, Please reach out to your administrator for assistance.",
                    ], 422);
                }
            }

            (new InvalidateIfUserIsInactive)($user);

            $personalTokenService = new PersonalTokenService($user);
            $personalTokenService->deleteTheExistingTokensOfDevices();
            // $isAlreadyLoggedIn = $personalTokenService->isLoggedInInOtherDevice();
            $tokenInstance = $personalTokenService->createToken();

            (new UpdateLoginInfo)($user, $request, $tokenInstance->accessToken);

            DB::commit();
            $user = Arr::except($user, ['mobile_verified_at','is_approved']);
            return response()->json([
                'message' => __('rest-auth::auth.signed_in'),
                'data' => [
                    'user' => $user,
                    'access_token' => $tokenInstance->plainTextToken,
                    'refresh_token' => $tokenInstance->plainTextRefreshToken,
                    'is_already_logged_in' => $isAlreadyLoggedIn ?? false,
                    'is_social_register' => 0
                ]
            ]);
        } catch (ValidationException $e) {

            DB::rollBack();
            return response()->json([
                'message' => $this->validator_message($e)
            ], 422);
        } catch (Exception $e) {

            DB::rollBack();
            return response()->json([
                'message' => $this->exception_message($e)
            ], 500);
        }
    }

    public function generateConditionalMatch($type, $username)
    {
        return match ($type) {
            'username' => ['username' => $username],
            'email' => ['email' => $username],
            'mobile' => "CONCAT(`isd_code`, `mobile`) = {$username}",
        };
    }

    public function sendOTPOnMobile($request)
    {
        $otp = $this->generateOTP();

        // Send SMS on mobile number via HTTP client
        $receiverNumber = '"' . $request->username . '"';
        if($request->device_type == "android")
        {
            if ($request->user_type == 1) {
                $message = "Your one time password for 4u taxi booking app is : " . $otp . ". fjmjoET9YaI";
            }
            else{
                $message = "Your one time password for 4u taxi booking app is : " . $otp . ". D5g134hIW39";
            }
        }
        else{
            $message = "Your one time password for 4u taxi booking app is " . $otp;
        }
        

        try {

            $account_sid = config('services.twilio.account_sid');
            $auth_token = config('services.twilio.auth_token');
            $twilio_number = config('services.twilio.twilio_number');

            $client = new Client($account_sid, $auth_token);
            $client->messages->create($receiverNumber, [
                'from' => $twilio_number,
                'body' => $message
            ]);

            // dd('SMS Sent Successfully.');

        } catch (Exception $e) {
            // dd("Error: ". $e->getMessage());
        }
        return $otp;
    }
}
