<?php

namespace App\Http\Controllers\APIs\v1;

use App\Http\Controllers\Controller;
use App\Models\CustomerHelpRequest;
use Illuminate\Http\Request;
use App\Models\HelpReason;
use Illuminate\Support\Facades\Validator;

class HelpController extends Controller
{
    public function get_list(Request $request)
    {
        $validator = Validator::make(['type' => $request->type], [
            'type' => 'required|integer|lte:2|gte:1',
        ]);
    
        if ($validator->fails()) {
            return response()->json([
                'message' => __('api.validation_failed'),
                'errors' => $validator->errors(),
            ], 422);
        }
    
        try {
            $reasons = HelpReason::select('id', 'reason')
                ->where('type', $request->type)
                ->where('is_active', 1)
                ->get();
    
            return response()->json([
                'message' => __('api.help.help_fetch_success'),
                'data' => $reasons,
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'message' => __('api.help.error_occurred'),
                'error' => $e->getMessage(),
            ], 500);
        }
    }

    public function send_request(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'help_reason_id' => 'required|exists:help_reasons,id',
            'description' => 'required|string',
        ]);
    
        if ($validator->fails()) {
            return response()->json([
                'message' => __('api.validation_failed'),
                'errors' => $validator->errors(),
            ], 422);
        }
    
        try {
            CustomerHelpRequest::create([
                'user_id' => auth()->user()->id,
                'help_reason_id' => $request->help_reason_id,
                'description' => $request->description,
            ]);
    
            return response()->json([
                'message' => __('api.help.submit_request'),
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'message' => __('api.help.request_failed'),
                'error' => $e->getMessage(),
            ], 500);
        }
    }

    public function check(Request $request)
    {
        $id=auth()->user()->id;
        dd($id);
    }
}
