<?php

namespace App\Http\Controllers\APIs\v1;

use App\Http\Requests\ForgotPasswordRequest;
use Symfony\Component\HttpFoundation\Response;
use SpaceO\RESTAuth\Http\Controllers\Controller;
use SpaceO\RESTAuth\Traits\Auth\ForgotPasswordTrait;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Notification;
use Illuminate\Support\Facades\Password;
use Illuminate\Validation\ValidationException;
use SpaceO\RESTAuth\Notifications\ForgotPasswordNotification;
use SpaceO\RESTAuth\RESTAuth;
use Exception;
use App\Models\Driver;

class ForgotPasswordController extends Controller
{
    
    use ForgotPasswordTrait;

    public function sendForgotPasswordLink(ForgotPasswordRequest $request)
    {

        try {

            DB::beginTransaction();

            if (config('rest_auth.reset_mode') === 'otp') {
                if($request->user_type == 1)
                {
                    $user = RESTAuth::$userModel::select('id', 'email')->where(['email'=> $request->email])->first();
                }
                else{
                    $user = Driver::select('id', 'email')->where(['email'=> $request->email])->first();
                }
                

                DB::table('password_resets')->where('email', $request->email)->delete();
                DB::table('password_resets')->insert([
                    'email'=>  $request->email,
                    'token'=> $token = $this->generateOTP(),
                    'created_at'=> now(),
                ]);

                Notification::send($user, new ForgotPasswordNotification($token));

                $status = Password::RESET_LINK_SENT;
            } else {

                if ($request->user_type == 1) {
                    // If user_type is 1, look for the email in the User model
                    $status = Password::sendResetLink(
                        $request->only('email')
                    );
                } elseif ($request->user_type == 2) {
                    // If user_type is 2, look for the email in the Driver model
                    $status = Password::broker('drivers')->sendResetLink(
                        $request->only('email')
                    );
                } else {
                    // Invalid user_type value
                    return response()->json([
                        'message' => 'Invalid user_type value.'
                    ], Response::HTTP_UNPROCESSABLE_ENTITY);
                }
            }

            DB::commit();
            
            return response()->json([
                'message'=> __($status) 
            ], $status === Password::RESET_LINK_SENT ? Response::HTTP_OK : Response::HTTP_UNPROCESSABLE_ENTITY);
        } catch (ValidationException $e) {

            return response()->json([ 
                'message' => $this->validator_message($e)
            ], Response::HTTP_UNPROCESSABLE_ENTITY);
        } catch (Exception $e) {
            
            return response()->json([
                'message' => $this->exception_message($e)
            ], Response::HTTP_INTERNAL_SERVER_ERROR);
        }
    }
}
