<?php

namespace App\Http\Controllers\APIs\v1;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Faq;
use Illuminate\Support\Facades\Validator;

class FaqController extends Controller
{
    public function get_list(Request $request)
    {
        $validator = Validator::make(['type' => $request->type], [
            'type' => 'required|integer|lte:2|gte:1',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'message' => __('api.validation_failed'),
                'errors' => $validator->errors(),
            ], 422);
        }

        try {
            $faqs = Faq::select('id', 'question', 'answer')->where('is_active', 1)->where('type', $request->type)->get();
            return response()->json([
                'message' => __('api.faq.faq_fetch_success'),
                'data' => $faqs
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'message' => __('api.faq.error_occured'),
                'error' => $e->getMessage(),
            ], 500);
        }
    }
}
