<?php

namespace App\Http\Controllers\APIs\v1;

use App\Exports\EarningDataExport;
use App\Http\Controllers\Controller;
use App\Http\Requests\EarningHistoryGraphRequest;
use App\Http\Requests\EarningHistoryListRequest;
use App\Http\Requests\ExportEarningDataRequest;
use App\Models\Booking;
use App\Models\BookingPayment;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Facades\Excel;
use \Mpdf\Mpdf as MPDF;

class EarningController extends Controller
{

    public function getEarningHistoryList(EarningHistoryListRequest $request)
    {
        $driver = auth()->user();
        $response['list'] = [];
        $response['grand_total_amount'] = 0;
        $earnings = DB::table('bookings')
            ->leftJoin('booking_payments', 'bookings.id', '=', 'booking_payments.booking_id')
            ->leftJoin('users', 'bookings.user_id', '=', 'users.id')
            ->where('bookings.driver_id', $driver->id);
        if ($request->has('filter_option') && !empty($request->filter_option)) {
            $earnings->where('booking_payments.payment_status', $request->filter_option);
        }
        if ($request->filter_type == 1) {

            $days_data = $earnings->select('bookings.booking_no', 'users.name as name', 'booking_payments.payment_amount as amount', 'booking_payments.created_at as datetime', 'booking_payments.payment_amount as amount', 'booking_payments.payment_status as status')->whereBetween('booking_payments.created_at', [Carbon::now()->startOfWeek(), Carbon::now()->endOfWeek()])->get();

            foreach ($days_data as $day_data) {
                $arr = [
                    'booking_no' => $day_data->booking_no,
                    'user_name' => $day_data->name,
                    'amount' => (float)$day_data->amount,
                    'datetime' => $day_data->datetime,
                    'status' => $day_data->status
                ];
                $response['list'][] = $arr;
            }
            $response['grand_total_amount'] = (float)$days_data->sum('amount');
        }
        if ($request->filter_type == 2) {

            $weeks_data =  $earnings->select('bookings.booking_no', 'users.name as name', 'booking_payments.payment_amount as amount', 'booking_payments.created_at as datetime', 'booking_payments.payment_amount as amount', 'booking_payments.payment_status as status')->whereMonth("booking_payments.created_at", Carbon::now()->month)->get();

            foreach ($weeks_data as  $week_data) {
                $arr = [
                    'booking_no' => $week_data->booking_no,
                    'user_name' => $week_data->name,
                    'amount' => (float)$week_data->amount,
                    'datetime' => $week_data->datetime,
                    'status' => $week_data->status
                ];
                $response['list'][] = $arr;
            }
            $response['grand_total_amount'] = (float)$weeks_data->sum('amount');
        }
        if ($request->filter_type == 3) {
            $months_data = $earnings->select('bookings.booking_no', 'users.name as name', 'booking_payments.payment_amount as amount', 'booking_payments.created_at as datetime', 'booking_payments.payment_amount as amount', 'booking_payments.payment_status as status')
                ->whereYear('booking_payments.created_at', date('Y'))
                ->whereYear('booking_payments.created_at', Carbon::now()->year)->get();
            foreach ($months_data as $month_data) {
                $arr = [
                    'booking_no' => $month_data->booking_no,
                    'user_name' => $month_data->name,
                    'amount' => (float)$month_data->amount,
                    'datetime' => $month_data->datetime,
                    'status' => $month_data->status
                ];
                $response['list'][] = $arr;
            }

            $response['grand_total_amount'] = (float)$months_data->sum('amount');
        }
        if ($request->filter_type == 4) {
            if ($request->from_date && $request->to_date) {
                $from_date = Carbon::parse($request->from_date);
                $to_date = Carbon::parse($request->to_date);

                $diff = $from_date->diffInDays($to_date);
                $data =  $earnings
                    ->when($diff == 0, function ($data) use ($request) {
                        $data->select(
                            'bookings.booking_no',
                            'users.name as name',
                            'booking_payments.payment_amount as amount',
                            'booking_payments.created_at as datetime',
                            'booking_payments.payment_amount as amount',
                            'booking_payments.payment_status as status'
                        )->where(DB::raw("DATE(booking_payments.created_at)"), $request->from_date);
                    })
                    ->when($diff > 0, function ($data) use ($request) {
                        $data->select(
                            'bookings.booking_no',
                            'users.name as name',
                            'booking_payments.payment_amount as amount',
                            'booking_payments.created_at as datetime',
                            'booking_payments.payment_amount as amount',
                            'booking_payments.payment_status as status'
                        )->where([[DB::raw("DATE(booking_payments.created_at)"), ">=", $request->from_date], [DB::raw("DATE(booking_payments.created_at)"), "<=", $request->to_date]]);
                    })
                    ->get();
                foreach ($data as $r_data) {
                    $arr = [
                        'booking_no' => $r_data->booking_no,
                        'user_name' => $r_data->name,
                        'amount' => (float)$r_data->amount,
                        'datetime' => $r_data->datetime,
                        'status' => $r_data->status
                    ];
                    $response['list'][] = $arr;
                }

                $response['grand_total_amount'] = (float)$data->sum('amount');
            }
        }
        $bookings = Booking::where('driver_id', $driver->id)
            ->with('payments')
            ->get();

        $totalEarningAmount = 0;

        foreach ($bookings as $booking) {
            foreach ($booking->payments as $payment) {
                $totalEarningAmount += $payment->payment_amount;
            }
        }

        $response['total_received_amount'] = (float)$totalEarningAmount;

        return response()->json([
            'message' => __('api.earning.success'),
            'data' => $response
        ]);
    }

    public function getEarningHistory(EarningHistoryGraphRequest $request)
    {
        $driverId = auth()->user()->id;
        $type = $request->filter_type;
        $data = getdefaultGrathData($type);
        $dateFormate = config("constant.charts_enum")['mysql'][$type];
        // dd($dateFormate);
        if ($type == 1) {
            $start = Carbon::now()->startOfWeek()->format("Y-m-d");
        } elseif ($type == 2) {
            $start = Carbon::now()->startOfMonth()->format("Y-m-d");
        } elseif ($type == 3) {
            $start = Carbon::now()->startOfYear()->format("Y-m-d");
        } else {
            $start = Carbon::now()->startOfWeek()->format("Y-m-d");
        }
        $graphData = DB::table('bookings')
            ->leftJoin('booking_payments', 'bookings.id', '=', 'booking_payments.booking_id')
            ->where('bookings.driver_id', $driverId)
            ->where('booking_payments.created_at', '>=', $start)
            ->when($type == 2, function ($q) use ($dateFormate) {
                $q->select(DB::raw("CONCAT('W-', $dateFormate) as date"));
            })
            ->when($type != 2, function ($q)  use ($dateFormate) {
                $q->select(DB::raw("DATE_FORMAT(booking_payments.created_at,'$dateFormate') as date"));
            })
            ->addSelect(DB::raw("IFNULL(SUM(booking_payments.payment_amount),0) as totalAmount"))
            ->groupBy('date')
            ->orderBy('booking_payments.created_at', 'desc')
            ->get();
        // dd($graphData->toArray());
        $final_data = $data->map(function ($dataa) use ($graphData) {
            if ($graphData->contains('date', $dataa)) {
                $datails = $graphData->firstWhere('date', $dataa);
                return collect([
                    "key" => $datails->date,
                    "value" => (float)$datails->totalAmount,
                ]);
            } else {
                return collect([
                    "key" => $dataa,
                    "value" => 0
                ]);
            }
        })->values()->toArray();
        $result['list'] = $final_data;
        $result['grand_total_amount'] = (float)$graphData->sum('totalAmount');
        $totalEarningAmount = DB::table('bookings')
            ->leftJoin('booking_payments', 'bookings.id', '=', 'booking_payments.booking_id')
            ->select(DB::raw("IFNULL(SUM(booking_payments.payment_amount),0) as totalAmount"))
            ->where('bookings.driver_id', $driverId)
            ->value('totalAmount');
        $result['total_received_amount'] = (float)$totalEarningAmount;
        return response()->json([
            'message' => __('api.earning.success'),
            'data' => $result
        ]);
    }

    public function ExportEarningData(ExportEarningDataRequest $request)
    {
        $url = "";
        $driver = auth()->user();
        $response['list'] = [];
        $response['grand_total_amount'] = 0;
        $earnings = DB::table('bookings')
            ->leftJoin('booking_payments', 'bookings.id', '=', 'booking_payments.booking_id')
            ->leftJoin('users', 'bookings.user_id', '=', 'users.id')
            ->where('bookings.driver_id', $driver->id);
        if ($request->has('filter_option') && !empty($request->filter_option)) {
            $earnings->where('booking_payments.payment_status', $request->filter_option);
        }
        if ($request->filter_type == 1) {

            $days_data = $earnings->select('bookings.booking_no', 'users.name as name', 'booking_payments.payment_amount as amount', 'booking_payments.created_at as datetime', 'booking_payments.payment_amount as amount', DB::raw('CASE
            WHEN booking_payments.payment_status = 1 THEN "Pending"
            WHEN booking_payments.payment_status = 2 THEN "Received"
            ELSE "Unknown"
            END as status'))->whereBetween('booking_payments.created_at', [Carbon::now()->startOfWeek(), Carbon::now()->endOfWeek()])->get();

            if ($request->export_type == 1) {
                $filename = 'earning/csv/earning_date_' . Carbon::now()->timestamp . '.csv';
                Excel::store(new EarningDataExport($days_data), $filename, 's3');
                $url = config('services.aws.aws_cloud_url') . $filename;
            } else {
                $filename = 'earning/pdf/earning_date_' . Carbon::now()->timestamp . '.pdf';
                $url = Excel::store(new EarningDataExport($days_data), $filename, 's3', \Maatwebsite\Excel\Excel::MPDF);
                $url = config('services.aws.aws_cloud_url') . $filename;
            }
        }
        if ($request->filter_type == 2) {

            $weeks_data =  $earnings->select('bookings.booking_no', 'users.name as name', 'booking_payments.payment_amount as amount', 'booking_payments.created_at as datetime', 'booking_payments.payment_amount as amount', DB::raw('CASE
            WHEN booking_payments.payment_status = 1 THEN "Pending"
            WHEN booking_payments.payment_status = 2 THEN "Received"
            ELSE "Unknown"
            END as status'))->whereMonth("booking_payments.created_at", Carbon::now()->month)->get();

            if ($request->export_type == 1) {
                $filename = 'earning/csv/earning_date_' . Carbon::now()->timestamp . '.csv';
                Excel::store(new EarningDataExport($weeks_data), $filename, 's3');
                $url = config('services.aws.aws_cloud_url') . $filename;
            } else {
                $filename = 'earning/pdf/earning_date_' . Carbon::now()->timestamp . '.pdf';
                $url = Excel::store(new EarningDataExport($weeks_data), $filename, 's3', \Maatwebsite\Excel\Excel::MPDF);
                $url = config('services.aws.aws_cloud_url') . $filename;
            }
        }
        if ($request->filter_type == 3) {
            $months_data = $earnings->select('bookings.booking_no', 'users.name as name', 'booking_payments.payment_amount as amount', 'booking_payments.created_at as datetime', 'booking_payments.payment_amount as amount', DB::raw('CASE
            WHEN booking_payments.payment_status = 1 THEN "Pending"
            WHEN booking_payments.payment_status = 2 THEN "Received"
            ELSE "Unknown"
            END as status'))
                ->whereYear('booking_payments.created_at', date('Y'))
                ->whereYear('booking_payments.created_at', Carbon::now()->year)->get();
            if ($request->export_type == 1) {
                $filename = 'earning/csv/earning_date_' . Carbon::now()->timestamp . '.csv';
                Excel::store(new EarningDataExport($months_data), $filename, 's3');
                $url = config('services.aws.aws_cloud_url') . $filename;
            } else {
                $filename = 'earning/pdf/earning_date_' . Carbon::now()->timestamp . '.pdf';
                $url = Excel::store(new EarningDataExport($months_data), $filename, 's3', \Maatwebsite\Excel\Excel::MPDF);
                $url = config('services.aws.aws_cloud_url') . $filename;
            }
        }
        if ($request->filter_type == 4) {
            if ($request->from_date && $request->to_date) {
                $from_date = Carbon::parse($request->from_date);
                $to_date = Carbon::parse($request->to_date);

                $diff = $from_date->diffInDays($to_date);
                $data =  $earnings
                    ->when($diff == 0, function ($data) use ($request) {
                        $data->select(
                            'bookings.booking_no',
                            'users.name as name',
                            'booking_payments.payment_amount as amount',
                            'booking_payments.created_at as datetime',
                            'booking_payments.payment_amount as amount',
                            DB::raw('CASE
                            WHEN booking_payments.payment_status = 1 THEN "Pending"
                            WHEN booking_payments.payment_status = 2 THEN "Received"
                            ELSE "Unknown"
                        END as status')
                        )->where(DB::raw("DATE(booking_payments.created_at)"), $request->from_date);
                    })
                    ->when($diff > 0, function ($data) use ($request) {
                        $data->select(
                            'bookings.booking_no',
                            'users.name as name',
                            'booking_payments.payment_amount as amount',
                            'booking_payments.created_at as datetime',
                            'booking_payments.payment_amount as amount',
                            DB::raw('CASE
                            WHEN booking_payments.payment_status = 1 THEN "Pending"
                            WHEN booking_payments.payment_status = 2 THEN "Received"
                            ELSE "Unknown"
                        END as status')
                        )->where([[DB::raw("DATE(booking_payments.created_at)"), ">=", $request->from_date], [DB::raw("DATE(booking_payments.created_at)"), "<=", $request->to_date]]);
                    })
                    ->get();
            }
            if ($request->export_type == 1) {
                $filename = 'earning/csv/earning_date_' . Carbon::now()->timestamp . '.csv';
                Excel::store(new EarningDataExport($data), $filename, 's3');
                $url = config('services.aws.aws_cloud_url') . $filename;
            } else {
                $filename = 'earning/pdf/earning_date_' . Carbon::now()->timestamp . '.pdf';
                $url = Excel::store(new EarningDataExport($data), $filename, 's3', \Maatwebsite\Excel\Excel::MPDF);
                $url = config('services.aws.aws_cloud_url') . $filename;
            }
        }

        return response()->json([
            'message' => __('api.earning.export_success'),
            'url' => $url
        ]);
    }
}
