<?php

namespace App\Http\Controllers\APIs\v1;

use Symfony\Component\HttpFoundation\Response;
use SpaceO\RESTAuth\Http\Controllers\Controller;
use SpaceO\RESTAuth\RESTAuth;

class ContentPageController extends Controller
{
    
    public function show($page_slug)
    {

        $contentPage = RESTAuth::$contentPageModel::query()
                    ->where('slug', $page_slug)
                    ->first();
        
        if (!$contentPage) {
            return response([
                'message'=> __('rest-auth::responses.not_found', ['thing'=> __('rest-auth::label.page')])
            ], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
        
        return response()->json([
            'message' => $contentPage->content,
        ], 200);
        
    }
}
