<?php

namespace App\Http\Controllers\APIs\v1;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Car;
use Illuminate\Support\Facades\DB;

class CarController extends Controller
{
    public function get_list(Request $request)
    {
    
        try {
            $aws_url = config('services.aws.aws_cloud_url');
            $cars = Car::select('id', 'car_type_name', 'car_description', 'car_capacity', 
            DB::raw("CONCAT('$aws_url', car_image) AS car_image"))
                ->where('is_active', 1)
                ->get();
    
            return response()->json([
                'message' => __('api.car_types.car_fetch_success'),
                'data' => $cars,
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'message' =>  __('api.car_types.error_occurred'),
                'error' => $e->getMessage(),
            ], 500);
        }
    }
}
