<?php

namespace App\Basecode\Middleware;

use Closure;
use Illuminate\Http\Request;

class AdminLocaleMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        $localeTobeSet = session('admin.locale') ?: 'en';
        
        if (!in_array($localeTobeSet, config('app.locales'))) {
            $localeTobeSet = config('app.fallback_locale');
        }
        
        session(['admin.locale' => $localeTobeSet]);
        app()->setLocale($localeTobeSet);

        return $next($request);
    }
}
