# 4U Web Admin 

## Made By Space-O Technologies

## Index

1. [Introduction](#introduction)
2. [Prerequisites](#prerequisites)
3. [Installation](#installation)
3. [Datatables](#datatables)
4. [Packages](#packages)
5. [Notes](#notes)

### Introduction

- Supports latest version of laravel i.e. Laravel 10 along with PHP 8.1. :zap:
- Authentication APIs are introduced to boost the development speed. :closed_lock_with_key:
- Swagger integration available to prepare APIs documentation. :nail_care:
- Swagger docummentation is ready to use for all the pre-implemented APIs. :sunglasses:
- Admin Panel introduced along with forgot & reset password. :european_castle:
- Update password feature in Admin Panel has been introduced. :eyes:
- In Admin Panel, "Content Pages" module CRUD has been added to deal with static pages directly in website. :bookmark_tabs:
- Localization mechanism in REST APIs are implemented to leverage the multi language support. :books:
- Country, State & Cities data seeder has been added.  :earth_asia:
- Sub Admins along with Roles & Permission feature has been added. :construction:

### Prerequisites

| **Plugin** | **Version**|
| ------ | ------ |
| VUE | ^3.2.36|
| PHP | ^8.1.0 |
| Composer | ^2.2.0 |
| Laravel | ^10.0 - 10.13.5 |
| Node | ^18.16.0|
| MySQL | ~8.0 |

### Installation


> ##### 1. Setting up your database details in .env

```sh
DB_DATABASE=DATABASE_NAME
DB_USERNAME=DATABASE_USER
DB_PASSWORD=DATABASE_PASSWORD
```

> ##### 2. Setup The Project

```sh
composer setup
```

> ##### 3. Run seeders to add some data to kickstart

```sh
php artisan db:seed --class=CountriesTableSeeder #If you are willing to add all countries alongs with states & cities then run following command
```
> ##### 4. Setup Node Socket Server
```sh
cd node_socket (directory node_socket)
node index.js
```
> ##### 5. Following accounts will be available @ ``/admin/login``

##### For client use

```html
admin@example.com
admin@spaceo
```

##### For developer use

```html
developer@example.com
developer@spaceo
```

###### 5. Swagger UI will be available @ ``/api/v1/documentation``

###### 6. Put Your Own Global JavaScript Code @ ``/resources/admin/global.js``

###### 7. Put Designer's CSS @ ``/resources/admin/styles.css``

###### 8. Put Your Own CSS @ ``/resources/admin/dev_styles.css``

- NOTE: After adding scripts & css use npm run watch using webpack.

<br />

### Packages

- [RestAuth](http://172.16.16.51:9999/snippets/157)
- [FCMLib](http://172.16.16.51:9999/snippets/160)

### Datatables
<hr>

#### Add Filters

> There are mainly 4 types of filters added in basecode.
- Text
- Select
- Date
- Date Range

<br />

-- ```filter-type``` attribute indicate the type of filter i.e. text, select, date, date-range. [REQUIRED]
<br />

-- ```filter-class``` attribute indicate the class names that you want to add in input. [OPTIONAL]
<br />

-- ```filter-name``` attribute indicate the input name. [REQUIRED]
<br />

-- ```filter-id``` attribute indicate the input id. [REQUIRED]

Example:
```
<tfoot>
    <tr>
        <th 
        filter-type="text" 
        filter-id="js-search-customer-name" 
        filter-name="search_customer_name"
        filter-classes="custom-class">Customer Name</th>
    </tr>
</tfoot>
```
### Notes

- Change the app name to your project's name.
- Change the admin panel credentials before starting development.
- Make sure [swagger](https://github.com/DarkaOnLine/L5-Swagger) & admin panel URLs must be in working position.
- You can download all the assets of [adminLTE 3](https://github.com/ColorlibHQ/AdminLTE/releases) if needed.
- Put your admin related assets inside `/public/admin_assets` directory.
- If you have any query contact (Mohammad Haris Rajput) harishr.spaceo@gmail.com
- For role & permission we have used spatie's [Laravel Permission](https://spatie.be/docs/laravel-permission/v5/introduction) package.
- For Country data we have gether the information from this repo : <https://github.com/dr5hn/countries-states-cities-database>
- If you dont have API requirements then please remove these packages: [darkaonline/l5-swagger](https://github.com/DarkaOnLine/L5-Swagger) & [spaceo/rest-auth](http://172.16.16.51:9999/snippets/157).
- If you dont have FCM notification requirement then you can remove [spaceo/fcmlib](http://172.16.16.51:9999/snippets/160) library.

**HAPPY CODING :+1: :computer:**